#pragma once

#include "MediaPlaylist.hpp"
#include "player/MediaRequest.hpp"
#include "playercore/platform/Platform.hpp"
#include <chrono>

namespace twitch {
namespace hls {
class PlaylistUpdater : public MediaRequest {
public:
    PlaylistUpdater();
    ~PlaylistUpdater() override;
    PlaylistUpdater(const PlaylistUpdater&) = delete;
    const PlaylistUpdater& operator=(const PlaylistUpdater&) = delete;

    using Clock = std::chrono::steady_clock;
    using TimePoint = Clock::time_point;

    void schedulePlaylist(const MediaPlaylist& playlist, Scheduler& scheduler, Scheduler::Action);
    void reset();
    void setScheduled(TimePoint timePoint);

private:
    TimePoint next(const MediaPlaylist& playlist);

    std::shared_ptr<Log> m_log;
    TimePoint m_scheduled;
    int m_latestSequenceNumber;
    int m_staleVariantCount;
};
}
}
