#include "Segment.hpp"

namespace twitch {
namespace hls {
Segment::ProgramTime Segment::ProgramTimeNone = Segment::ProgramTime::min();

std::string getAbsoluteURL(const std::string& base, const std::string& relative)
{
    static const std::string PROTOCOL = "://";

    if (relative.find(PROTOCOL) != std::string::npos) {
        return relative;
    }

    if (relative.front() != '/') {
        return base.substr(0, base.rfind('/') + 1) + relative;
    }

    size_t domainStart = base.find(PROTOCOL) + PROTOCOL.size();
    size_t pathStart = base.find('/', domainStart);
    return base.substr(0, pathStart) + relative;
}

bool Segment::isNextAfter(const Segment& prev) const
{
    return sequenceNumber == prev.sequenceNumber + 1;
}

std::string Segment::getAbsoluteUrl(const std::string& baseUrl) const
{
    return getAbsoluteURL(baseUrl, url);
}

std::string Segment::getInitializationSegmentUrl(const std::string& baseUrl) const
{
    if (!isInitialization && !!initializationSegment) {
        return initializationSegment->getAbsoluteUrl(baseUrl);
    }

    return std::string();
}
}
}
