#pragma once

#include "Rendition.hpp"
#include "Segment.hpp"
#include "media/MediaReader.hpp"
#include "player/MediaRequest.hpp"

namespace twitch {
namespace hls {
class SegmentRequest : public MediaRequest {
public:
    SegmentRequest();
    bool isDiscontinuitySeek() const;
    bool isDiscontinuitySequence() const;
    bool isDiscontinuityAdaptive() const;
    bool isDiscontinuityInitialization(const std::string& baseUrl) const;
    int getSequenceNumber() const { return m_sequenceNumber; }
    void setSequenceNumber(int sequenceNumber) { m_sequenceNumber = sequenceNumber; }
    void setSegment(const Segment& segmentInfo);
    int getMediaBitrate() const override { return m_bitrate; }
    void setMediaBitrate(int bitrate) { m_bitrate = bitrate; }
    const Segment& getSegment() const { return m_segment; }
    void setReader(std::unique_ptr<media::MediaReader> reader) { m_reader = std::move(reader); };
    media::MediaReader* getReader() { return m_reader.get(); }
    void onDiscontinuity();
    Rendition getRendition() { return m_rendition; }
    void setRendition(Rendition rendition) { m_rendition = rendition; }
    bool isMediaPrefetch() const override;
    bool isRangeRequest() const override { return m_segment.rangeLength > 0; }
    bool isProbe() const { return m_probe; }
    void setProbe(bool probe) { m_probe = probe; }

    void addData(const uint8_t* data, size_t size, bool endOfStream);
    void onCompleted() override;
    void onVariantChange(bool adaptive);
    void onSeek();
    void onRequest(std::shared_ptr<HttpRequest> request) override;
    void onResponse(const HttpResponse& response) override;

private:
    int m_sequenceNumber;
    int m_bitrate;
    Segment m_lastSegment;
    Segment m_segment;
    bool m_discontinuityAdaptive;
    bool m_discontinuitySeek;
    bool m_probe;
    MediaTime m_segmentStart;
    std::unique_ptr<media::MediaReader> m_reader;
    Rendition m_rendition;
};
}
}
