#pragma once
#include "playercore/MediaSample.hpp"
#include <functional>
#include <json11.hpp>

extern "C" {
#include <caption/avc.h>
#include <caption/caption.h>
}

namespace twitch {
namespace media {
class CEACaptions {
public:
    explicit CEACaptions(std::function<void(std::shared_ptr<MediaSampleBuffer>)> onFrame);
    ~CEACaptions();
    void reset();

    void fromMediaSampleBuffer(const std::shared_ptr<MediaSampleBuffer>& avc);

private:
    caption_frame_t m_captionFrame;
    std::function<void(std::shared_ptr<MediaSampleBuffer>)> m_onFrame;
};
}
}
