#pragma once

#include "MediaType.hpp"
#include <cstdint>
#include <map>
#include <string>
#include <vector>

namespace twitch {
namespace media {
/**
 * Represents the codec data inside the mime type codecs parameter. (https://tools.ietf.org/html/rfc6381)
 */
struct CodecString {
    // these are the only formats we support currently
    static const std::string avc1;
    static const std::string mp4a;
    static const std::string vp09;

    CodecString() = default;
    std::string format() const;
    static CodecString parse(const std::string& codecs);
    static MediaType getMediaType(const std::string& type);

    struct AVCParameters {
        uint8_t profile;
        uint8_t constraintFlags;
        uint8_t level;
    };
    void parseAVCParameters(AVCParameters& parameters);

    struct VP9Parameters {
        uint8_t profile;
        uint8_t level;
        uint8_t bitDepth;
        uint8_t chromaSubsampling;
        bool videoFullRangeFlag;
        uint8_t colourPrimaries;
        uint8_t transferCharacteristics;
        uint8_t matrixCoefficients;
    };
    void parseVP9Parameters(VP9Parameters& parameters);

    static void split(const std::string& input, std::vector<std::string>& values, char delimiter);

    std::map<std::string, std::string> values;
};
}
}
