#include "FileReaderFactory.hpp"
#include "FragmentReader.hpp"
#include "mp2t/Mp2TReader.hpp"
#include "mp4/Mp4Reader.hpp"

namespace twitch {
namespace media {
std::unique_ptr<MediaReader> FileReaderFactory::createReader(Platform& platform,
    MediaReader::Listener& listener,
    const MediaType& type, MediaReader::TrackId track, const std::string& url)
{
    if (m_passthroughMode) {
        return std::unique_ptr<media::FragmentReader>(new media::FragmentReader(platform, listener, type, track, url, true));
    }
    (void)track;
    std::unique_ptr<MediaReader> reader;
    if (type.matches(MediaType::Video_MP2T)) {
        reader.reset(new Mp2TReader(platform, listener, url));
    } else if (type.matches(MediaType::Video_MP4)) {
        reader.reset(new Mp4Reader(platform, listener, url));
    }
    return reader;
}
}
}
