#pragma once

#include "MediaReaderFactory.hpp"

namespace twitch {
namespace media {
class FileReaderFactory : public MediaReaderFactory {
public:
    ~FileReaderFactory() override = default;

    std::unique_ptr<MediaReader>
    createReader(Platform& platform, MediaReader::Listener& listener, const MediaType& type, MediaReader::TrackId track, const std::string& url) override;

    void setPassthrough(bool enable) { m_passthroughMode = enable; }

private:
    bool m_passthroughMode = false;
};
}
}
