#pragma once

#include "CEACaptions.hpp"
#include "MediaReader.hpp"
#include "Stream.hpp"
#include "mp2t/TransportStream.hpp"
#include "mp4/Mp4Parser.hpp"
#include "playercore/MediaSource.hpp"
#include "playercore/MediaTime.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
namespace media {
/**
 * FragmentReader buffers an entire or partial media segment and delivers it as a single
 * MediaSampleBuffer. This used as a passthrough mode for fmp4 on browsers and .ts for iOS.
 */
class FragmentReader : public MediaReader, private TransportStream::Listener {
public:
    FragmentReader(const Platform& platform, MediaReader::Listener& listener, const MediaType& mediaType,
        TrackId trackId, const std::string& path = "", bool outputPartialTS = false);
    ~FragmentReader() override = default;
    void seekTo(MediaTime time) override;
    void addData(const uint8_t* data, size_t size, bool endOfStream) override;
    void onDiscontinuity(uint32_t flags) override;
    void readSamples(MediaTime duration) override;
    void reset() override;
    std::shared_ptr<const MediaFormat> getTrackFormat(TrackId id) override;
    void setDuration(MediaTime duration) override;
    void setOutputPartial(bool enabled) { m_outputPartial = enabled; }
    void setStream(std::unique_ptr<Stream> stream) override;
    MediaTime getDuration() const override { return m_cumulativeDuration; }

private:
    void onElementaryDiscontinuity(uint8_t stream) override;
    void onElementarySample(uint8_t stream, const std::shared_ptr<MediaSampleBuffer>& sample) override;
    void resetParserStream();
    MediaTime getFragmentDecodeTime();
    MediaTime getOutputDuration();
    void createMetadataTrack();
    void createWebVTTTrack();
    void outputFragment(int64_t endPosition, bool endOfStream);

    MediaType m_mediaType;
    bool m_isFragmentedMP4;
    bool m_outputPartial;
    MediaReader::TrackId m_trackId;
    std::string m_path;
    MediaReader::Listener& m_listener;
    std::shared_ptr<Log> m_log;
    std::string m_quality;
    bool m_discontinuity;
    bool m_syncSample;
    MediaTime m_cumulativeDuration;
    MediaTime m_mediaDuration;
    MediaTime m_lastOutputDuration;
    std::unique_ptr<Stream> m_stream;
    std::unique_ptr<Mp4Parser> m_mp4parser;
    std::unique_ptr<TransportStream> m_tsparser;
    std::vector<std::shared_ptr<Mp4Track>> m_metaTracks;
    std::unique_ptr<CEACaptions> m_ceaCaptions;
    std::map<TrackId, std::shared_ptr<MediaFormat>> m_formats;
};
}
}
