#pragma once

#include "Stream.hpp"
#include "fourcc.hpp"
#include "playercore/Error.hpp"
#include "playercore/MediaFormat.hpp"
#include "playercore/MediaSample.hpp"
#include "playercore/MediaTime.hpp"
#include <memory>
#include <string>

namespace twitch {
namespace media {
class MediaReader {
public:
    enum TrackId : int {
        AudioTrackId = fourcc("soun"),
        VideoTrackId = fourcc("vide"),
        TextTrackId = fourcc("text"),
        MetaTrackId = fourcc("meta")
    };

    enum DiscontinuityFlag : uint32_t {
        DiscontinuityNone = 0,
        DiscontinuityFormat = 1,
        DiscontinuitySeek = 2,
        DiscontinuitySequence = 4,
        DiscontinuityAdaptive = 8,
    };

    class Listener {
    public:
        virtual void onMediaDurationChanged(MediaTime duration) = 0;
        virtual void onMediaEndOfStream() = 0;
        virtual void onMediaError(const Error& error) = 0;
        virtual void onMediaFlush() = 0;
        virtual void onMediaSample(int track, const std::shared_ptr<MediaSampleBuffer>& sample) = 0;
        virtual void onMediaTrack(int track, const std::shared_ptr<MediaFormat>& format) = 0;
    };

    MediaReader() = default;
    virtual ~MediaReader() = default;
    virtual void addData(const uint8_t* data, size_t size, bool endOfStream) = 0;
    virtual void onDiscontinuity(uint32_t flags) = 0;
    virtual void readSamples(MediaTime duration) = 0;
    virtual void seekTo(MediaTime time) = 0;
    virtual std::shared_ptr<const MediaFormat> getTrackFormat(TrackId id) = 0;
    virtual MediaTime getDuration() const = 0;
    virtual void reset() = 0;
    virtual void setDuration(MediaTime duration) = 0;
    virtual void setStream(std::unique_ptr<Stream> stream) = 0;
};
}
}
