#pragma once

#include "MediaReader.hpp"
#include "playercore/platform/Platform.hpp"
#include <memory>

namespace twitch {
class MediaReaderFactory {
public:
    virtual ~MediaReaderFactory() = default;

    /**
     * Creates a media format reader for the given media type, this allows the platform to vary
     * supported media types based on the platform.
     *
     * @param platform instance
     * @param listener MediaSource listener to forward requests to
     * @param type media type of the input format
     * @param track track id (optional if the format should be delivered on a specific track id)
     * @param url source url of the media
     * @return MediaReader instance for the given type or empty pointer if not supported.
     */
    virtual std::unique_ptr<media::MediaReader>
    createReader(Platform& platform, media::MediaReader::Listener& listener, const MediaType& type, media::MediaReader::TrackId track, const std::string& url) = 0;
};
}
