#pragma once

#include "media/Stream.hpp"
#include <cstdint>
#include <vector>

namespace twitch {
class MemoryStream : public Stream {
public:
    static constexpr size_t DefaultBlockSize = 512 * 1024;
    explicit MemoryStream(size_t blockSize = DefaultBlockSize);
    ~MemoryStream() override = default;
    int64_t read(uint8_t* buffer, size_t size) override;
    int64_t write(const uint8_t* buffer, size_t size) override;
    bool seek(size_t position) override;
    int64_t length() const override;
    int64_t position() const override { return m_position; }
    bool flush() override { return true; }
    int error() const override { return 0; }
    void close() override {}
    std::vector<uint8_t> take(int64_t bytes);
    void remove(int64_t bytes);

private:
    size_t getBlockStartOffset(size_t index);
    void erase(size_t index);

    std::vector<std::vector<uint8_t>> m_buffers;
    size_t m_position;
    size_t m_index;
    size_t m_blockSize;
};
}
