#pragma once

namespace twitch {
namespace media {
struct Resolution {
    int width = 0;
    int height = 0;

    Resolution() = default;
    Resolution(int w, int h)
        : width(w)
        , height(h)
    {
    }

    int area() const { return width * height; }
    bool operator>(const Resolution& other) const { return area() > other.area(); }
    bool operator<(const Resolution& other) const { return area() < other.area(); }
};
}
}
