#include "SourceFormat.hpp"

namespace twitch {
namespace media {
std::shared_ptr<SourceFormat>
SourceFormat::createAudioFormat(const MediaType& type, int channelCount, int sampleRate, int sampleSize)
{
    auto format = std::make_shared<SourceFormat>(type);
    format->m_intvalues[Attribute::Audio_ChannelCount] = channelCount;
    format->m_intvalues[Attribute::Audio_SampleRate] = sampleRate;
    format->m_intvalues[Attribute::Audio_SampleSize] = sampleSize;
    return format;
}

std::shared_ptr<SourceFormat>
SourceFormat::createVideoFormat(const MediaType& type, int width, int height)
{
    auto format = std::make_shared<SourceFormat>(type);
    format->m_intvalues[Attribute::Video_Width] = width;
    format->m_intvalues[Attribute::Video_Height] = height;
    return format;
}

SourceFormat::SourceFormat(const MediaType& type, std::string name)
    : m_name(std::move(name))
    , m_type(type)
{
}

bool SourceFormat::operator==(const SourceFormat& other) const
{
    return m_type == other.m_type && m_data == other.m_data && m_intvalues == other.m_intvalues;
}

bool SourceFormat::operator!=(const SourceFormat& other) const
{
    return !(*this == other);
}

void SourceFormat::reset()
{
    m_data.clear();
    m_intvalues.clear();
}
}
}
