#pragma once

#include "playercore/MediaFormat.hpp"
#include <memory>
#include <utility>

namespace twitch {
namespace media {
class SourceFormat final : public MediaFormat {
public:
    static std::shared_ptr<SourceFormat>
    createAudioFormat(const MediaType& type, int channelCount, int sampleRate, int sampleSize);

    static std::shared_ptr<SourceFormat>
    createVideoFormat(const MediaType& type, int width, int height);

    SourceFormat() = default;
    explicit SourceFormat(const MediaType& type, std::string name = std::string());
    ~SourceFormat() override = default;

    bool operator==(const SourceFormat& other) const;
    bool operator!=(const SourceFormat& other) const;

    const std::string& getName() const override { return m_name; }
    const std::string& getPath() const override { return m_path; }
    const MediaType& getType() const override { return m_type; }
    bool hasCodecData(CodecData key) const override { return m_data.count(key) > 0; }
    const std::vector<uint8_t>& getCodecData(CodecData key) const override { return m_data.at(key); }
    int getInt(Attribute key) const override { return m_intvalues.at(key); }
    bool hasInt(Attribute key) const override { return m_intvalues.count(key) > 0; }
    const std::map<CodecData, std::vector<uint8_t>>& getCodecData() const override { return m_data; }
    const std::map<Attribute, int>& getValues() const override { return m_intvalues; }
    const std::vector<std::vector<uint8_t>>& getProtectionData() const override { return m_protectionData; }

    void setName(const std::string& name) override { m_name = name; }
    void setPath(const std::string& name) override { m_path = name; }
    void setType(const MediaType& type) override { m_type = type; }
    void setCodecData(CodecData key, const std::vector<uint8_t>& data) override { m_data[key] = data; }
    void setInt(Attribute key, int value) override { m_intvalues[key] = value; }
    void setCodecData(const std::map<CodecData, std::vector<uint8_t>>& data) override { m_data = data; }
    void setProtectionData(const std::vector<std::vector<uint8_t>>& data) override { m_protectionData = data; }
    void setValues(const std::map<Attribute, int>& values) override { m_intvalues = values; }

    void reset();

private:
    std::string m_name;
    std::string m_path;
    // include any format specific data in equals operator
    MediaType m_type;
    std::map<CodecData, std::vector<uint8_t>> m_data;
    std::map<Attribute, int> m_intvalues;
    std::vector<std::vector<uint8_t>> m_protectionData;
};
}
}
