#pragma once
#include <stddef.h>
#include <stdint.h>
#include <vector>

#define AAC_DEFAULT_HEADER_SIZE 7
#define AAC_EXTENDED_HEADER_SIZE 9
#define AAC_SAMPLES_PER_FRAME 1024
#define AAC_SYNC_WORD 0x0FFF

// perchannel
#define AAC_MIN_BITRATE 4000
#define AAC_MAX_BITRATE 384000

struct adts_t {
    unsigned syncWord;
    unsigned protectionAbsent;
    unsigned objectType;
    unsigned frequencyIndex;
    unsigned channelConfig;
    unsigned frameSize;
    unsigned bufferSize;
    unsigned frameCount;
    unsigned sampleCount;
    unsigned crc;
};

void aac_init_adts(adts_t* adts);
int aac_parse_adts(adts_t* adts, const uint8_t* data, size_t size);
int aac_parse_extradata(adts_t* adts, const uint8_t* data, size_t size);
int aac_render_adts(const adts_t* adts, uint8_t* data); // data must be at least 7 bytes
int aac_render_extradata(const adts_t* adts, uint8_t* data, size_t size);
int aac_element_instance_tag(const uint8_t* data);
int aac_channels(const adts_t* adts);

unsigned aac_frequency_from_index(unsigned index);
inline unsigned aac_header_size(const adts_t* adts) { return adts->protectionAbsent ? AAC_DEFAULT_HEADER_SIZE : AAC_EXTENDED_HEADER_SIZE; }
inline unsigned aac_frequency(const adts_t* adts) { return aac_frequency_from_index(adts->frequencyIndex); }

enum aacSanity {
    kAacOk = 0,
    kAacInvalidSyncWord = -1,
    kAacFrameSmallerThanHeader = -2,
    kAacInvalidFrequency = -3,
    kAacInvalidChannelValue = -4,
    kAacInvalidFrameSize_TooSmall = -5,
    kAacInvalidFrameSize_TooLarge = -6,
    kAacInvalidFrameCount = -7,
};
enum aacSanity aac_sanity(const adts_t* adts);

std::vector<uint8_t> aac_silent_frame(int channles, int frequency_index, int element_instance_tag);
