#pragma once

#include <cstdint>
#include <string>

namespace twitch {
namespace media {
constexpr uint32_t fourcc(const char* s)
{
    return (static_cast<uint32_t>(s[0]) << 24)
        | (static_cast<uint32_t>(s[1]) << 16)
        | (static_cast<uint32_t>(s[2]) << 8)
        | static_cast<uint32_t>(s[3]);
}

inline std::string fourccString(uint32_t code)
{
    return std::string({ static_cast<char>(code >> 24),
        static_cast<char>(code >> 16),
        static_cast<char>(code >> 8),
        static_cast<char>(code) });
}
}
}
