#pragma once

#include "../aac/aacutil.hpp"
#include "ElementaryStream.hpp"

namespace twitch {
namespace media {
class ElementaryStreamAac : public ElementaryStream {
public:
    ElementaryStreamAac(uint16_t pid, TransportStream* ts);
    ~ElementaryStreamAac() override;
    void reset() override;
    void startFrame(int64_t dts, int32_t cts, int data_alignment) override;
    void finishFrame(int64_t dts) override;
    void addData(const uint8_t* data, size_t size) override;
    std::vector<uint8_t> extradata() const override;

private:
    void flush() override;
    void addSilentFrames(int count);

    int64_t m_bufferDts;
    int64_t m_sampleCount;
    unsigned m_frequency;
    int m_element_instance_tag;
    std::vector<uint8_t> m_buffer;
    adts_t m_adts = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
};
}
}
