#pragma once

#include "../avc/avcutil.hpp"
#include "ElementaryStream.hpp"

namespace twitch {
namespace media {
class ElementaryStreamAvc : public ElementaryStream {
public:
    ElementaryStreamAvc(uint16_t pid, TransportStream* ts);
    ~ElementaryStreamAvc() override;
    void reset() override;
    void startFrame(int64_t dts, int32_t cts, int data_alignment) override;
    void finishFrame(int64_t dts) override;
    void addData(const uint8_t* data, size_t size) override;
    int64_t maxCts() const override { return DefaultFrameDuration * 16; } // AVC is 16 reference frames max
    std::vector<uint8_t> extradata() const override { return m_extradata; }

private:
    void flushFrame();
    void finishFrame();
    void addNalu(const std::vector<uint8_t>& nalu);
    void flush() override;

    std::vector<uint8_t> m_buffer;
    MediaTime m_outputDts;
    NalBuffer m_frameBuf;
    std::vector<uint8_t> m_extradata;
    std::shared_ptr<MediaSampleBuffer> m_frameA;
    std::shared_ptr<MediaSampleBuffer> m_frameB;
    MediaTime m_droppedFrameDuration;
};
}
}
