#include "ElementaryStreamId3.hpp"
#include "../id3/id3.hpp"
#include "debug/trace.hpp"

namespace twitch {
namespace media {
ElementaryStreamId3::ElementaryStreamId3(uint16_t pid, TransportStream* ts)
    : ElementaryStream(pid, TypeID3, ts)
    , m_bufferDts(TSTimestampUndefined)
{
}

ElementaryStreamId3::~ElementaryStreamId3()
{
    reset();
}

void ElementaryStreamId3::reset()
{
    m_bufferDts = TSTimestampUndefined;
    m_buffer.clear();
}

void ElementaryStreamId3::startFrame(int64_t dts, int32_t cts, int data_alignment)
{
    if (data_alignment) {
        flush();
    }

    (void)cts;
    m_bufferDts = dts;

    if (remaining() + m_buffer.size() > m_buffer.capacity()) {
        m_buffer.reserve(static_cast<size_t>(1.5 * (remaining() + m_buffer.size())));
    }
}

void ElementaryStreamId3::finishFrame(int64_t dts)
{
    m_bufferDts = dts;
}

void ElementaryStreamId3::addData(const uint8_t* data, size_t size)
{
    if (TSTimestampUndefined >= m_bufferDts) {
        TRACE_DEBUG("Received data with unknown pts");
        return;
    }

    m_buffer.insert(m_buffer.end(), data, data + size);

    // TODO verify id3 is not continued in next pes
    if (!remaining()) {
        MediaTime timestamp(m_bufferDts, TSTimeScale);
        auto frames = media::Id3::parseFrames(m_buffer, timestamp);
        for (const auto& frame : frames) {
            emitFrame(frame);
        }
        m_buffer.clear();
    }
}

void ElementaryStreamId3::flush()
{
    if (!m_buffer.empty()) {
        TRACE_WARN("ElementaryStream_Id3() flush called with %d bytes buffered", m_buffer.size());
        m_buffer.clear();
    }
}
}
}
