#pragma once

#include "ElementaryStream.hpp"

namespace twitch {
namespace media {
class ElementaryStreamId3 : public ElementaryStream {
public:
    ElementaryStreamId3(uint16_t pid, TransportStream* ts);
    ~ElementaryStreamId3() override;
    void reset() override;
    void startFrame(int64_t dts, int32_t cts, int data_alignment) override;
    void finishFrame(int64_t dts) override;
    void addData(const uint8_t* data, size_t size) override;
    int64_t minDtsDelta() const override { return 0; }
    int64_t maxDtsDelta() const override { return TSTimestampMax; }
    std::vector<uint8_t> extradata() const override { return std::vector<uint8_t>(); }

private:
    int64_t m_bufferDts;
    std::vector<uint8_t> m_buffer;
    void flush() override;
};
}
}
