#pragma once

#include "TransportStream.hpp"
#include "media/CEACaptions.hpp"
#include "media/MediaReader.hpp"
#include "playercore/MediaSource.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
namespace media {
/**
 * Samples MPEG-2 Transport Stream from a media segment or from a file.
 */
class Mp2TReader : public MediaReader, private TransportStream::Listener {
public:
    Mp2TReader(const Platform& platform, MediaReader::Listener& listener, const std::string& path = "");
    ~Mp2TReader() override;
    void seekTo(MediaTime time) override;
    void addData(const uint8_t* data, size_t size, bool endOfStream) override;
    void readSamples(MediaTime duration) override;
    void reset() override;
    std::shared_ptr<const MediaFormat> getTrackFormat(TrackId id) override;
    void onDiscontinuity(uint32_t flags) override;
    void setDuration(MediaTime) override {};
    void setStream(std::unique_ptr<Stream> stream) override;
    MediaTime getDuration() const override;

private:
    void onElementaryDiscontinuity(uint8_t type) override;
    void onElementarySample(uint8_t stream, const std::shared_ptr<MediaSampleBuffer>& sample) override;
    void createAACFormat(const std::vector<uint8_t>& extradata);
    void createAVCFormat(const std::vector<uint8_t>& extradata);

    std::string m_path;
    std::unique_ptr<CEACaptions> m_captions;
    std::unique_ptr<TransportStream> m_parser;
    MediaReader::Listener& m_listener;
    AVCFormatType m_avcFormat;
    std::shared_ptr<Log> m_log;
    std::map<TrackId, std::shared_ptr<MediaFormat>> m_formats;
    std::unique_ptr<Stream> m_stream;
    std::map<int, int> m_trackSampleCounts;
};
}
}
