#pragma once

#include "../fourcc.hpp"
#include "ElementaryStream.hpp"
#include "playercore/MediaSample.hpp"
#include <functional>
#include <map>
#include <memory>

namespace twitch {
namespace media {
class TransportStream {
public:
    class Listener {
    public:
        virtual void onElementaryDiscontinuity(uint8_t stream) = 0;
        virtual void onElementarySample(uint8_t stream, const std::shared_ptr<MediaSampleBuffer>& sample) = 0;
    };

    explicit TransportStream(Listener& listener);
    ~TransportStream();

    // finish MUST only be called at the end of a stream, or just before discontinuity()
    void finish();
    //Seek will force a reset() and update base media decode times
    void seek(int64_t timestamp);
    void reset();
    void addData(const uint8_t* data, size_t size);

    void emitFrame(const ElementaryStream& stream, const std::shared_ptr<MediaSampleBuffer>& frame);

    int64_t duration() const { return m_mediaDuration; }
    int16_t metaPid() const { return m_metapid; }
    int16_t audioPid() const { return m_audiopid; }
    int16_t videoPid() const { return m_videopid; }
    std::vector<uint8_t> audioExtradata() const { return m_map.at(m_audiopid)->extradata(); }
    std::vector<uint8_t> videoExtradata() const { return m_map.at(m_videopid)->extradata(); }

private:
    Listener& m_listener;
    std::function<void(uint8_t, std::shared_ptr<MediaSampleBuffer>)> m_onFrame;
    int64_t m_pcr;
    int16_t m_pcrext;
    int16_t m_pmtpid;
    int16_t m_pcrpid;
    int16_t m_metapid;
    int16_t m_videopid;
    int16_t m_audiopid;
    int64_t m_timeOffset;
    int64_t m_mediaDuration;
    std::vector<uint8_t> m_buffer; // buffer partial packets internally
    std::map<int16_t, std::unique_ptr<ElementaryStream>> m_map;
    bool parsePacket(const uint8_t* data); // Assumes at least 188 bytes are available
};
}
}
