#pragma once

#include "media/fourcc.hpp"
#include <array>
#include <cstdint>
#include <string>
#include <vector>

namespace twitch {
namespace media {
using IV_t = std::vector<uint8_t>;
using Key_t = std::array<uint8_t, 16>;
using KeyId_t = std::array<uint8_t, 16>;

static const size_t AesBlockSize = (1 << 4);

struct EncryptionInfo {
    IV_t iv;
    Key_t key;
    KeyId_t kid;
    uint32_t scheme;
    std::string lic_acq_url;
    std::vector<std::vector<uint8_t>> pssh;
    EncryptionInfo()
        : key { { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
        , kid { { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
        , scheme(0)
    {
    }

    void incrementIv();
    bool useConstantIv() const { return 0 == perSampleIvSize(); }
    uint8_t perSampleIvSize() const
    {
        return fourcc("cbcs") == scheme ? 0 : static_cast<uint8_t>(iv.size());
    }
    uint8_t patternEncryption() const
    {
        return fourcc("cbcs") == scheme ? 0x19 : 0x00;
    }
    uint8_t cryptByteBlock() const
    {
        return 0x0f & (patternEncryption() >> 4);
    }
    uint8_t skipByteBlock() const
    {
        return 0x0f & patternEncryption();
    }
};
}
}
