#pragma once

#include "EncryptionInfo.hpp"
#include "SampleEncrypter.hpp"
#include "media/ProtectionSystem.hpp"
#include "media/fourcc.hpp"
#include <array>
#include <cinttypes>
#include <map>
#include <memory>
#include <string>
#include <vector>

namespace twitch {
namespace media {
class Mp4DrmFactory {
public:
    static std::shared_ptr<SampleEncrypter> configure(uint32_t scheme, const Key_t& key, const IV_t& iv);

    static std::vector<uint8_t> generatePssh(const Uuid& systemId, const std::vector<KeyId_t>& kids, const uint8_t* data, size_t size);
    static std::vector<uint8_t> generateTwitchPssh(const KeyId_t& kid);
    static std::vector<uint8_t> generateWidevinePssh(const std::vector<uint8_t>& payload);
    static std::vector<uint8_t> generatePlayReadyPssh(const std::string& payload); // Must be utf8

    static std::vector<EncryptionInfo> parseSkelligeJson(const std::string& data, const std::string& scheme_type = "cenc");
    static std::vector<EncryptionInfo> clearKeyTestInfo();
};
}
}
