#pragma once

#include "Mp4Parser.hpp"
#include "media/CEACaptions.hpp"
#include "media/MediaReader.hpp"
#include "playercore/MediaSource.hpp"
#include "playercore/TimeRange.hpp"
#include "playercore/platform/Platform.hpp"
#include <map>
#include <string>
#include <vector>

namespace twitch {
namespace media {
/**
 * Samples an MP4 progressively or samples fragmented MP4 media segments.
 */
class Mp4Reader : public MediaReader {
public:
    Mp4Reader(Platform& platform, MediaReader::Listener& listener, const std::string& path = "");
    ~Mp4Reader() override = default;
    void seekTo(MediaTime time) override;
    void reset() override;
    void addData(const uint8_t* data, size_t size, bool endOfStream) override;
    void onDiscontinuity(uint32_t) override;
    void readSamples(MediaTime duration) override;
    std::shared_ptr<const MediaFormat> getTrackFormat(TrackId id) override;
    MediaTime getDuration() const override;
    void setDuration(MediaTime) override {};
    void setStream(std::unique_ptr<Stream> stream) override;

private:
    MediaTime getBaseDecodeTime() const;
    void readEmsgs();
    std::shared_ptr<MediaFormat> createTrackFormat(const Mp4Track& track);
    std::shared_ptr<MediaFormat> createAVCFormat(const Mp4Track& track);
    std::shared_ptr<MediaFormat> createAACFormat(const Mp4Track& track);
    std::shared_ptr<MediaFormat> createVP9Format(const Mp4Track& track);
    void createMetadataTrack();
    static MediaReader::TrackId getStableTrackId(const Mp4Track& track);
    void load();
    void initializeTracks();
    void resetParserStream();
    void handleStreamError(const std::string& message);
    void handleTrackData(const Mp4Track& track, const std::shared_ptr<MediaSampleBuffer>& sample);
    bool avcContainsIDRSlice(const std::vector<uint8_t>& buffer);
    void avcConvertToAnnexB(const MediaFormat& format, MediaSampleBuffer& sample);
    void createVTTSample(const std::vector<uint8_t>& data, std::string& text);
    static uint16_t readUint16(const uint8_t* data, size_t& offset);
    static uint32_t readUint32(const uint8_t* data, size_t& offset);

    MediaReader::Listener& m_listener;
    std::string m_path;
    Mp4Parser m_parser;
    Platform& m_platform;
    std::shared_ptr<Log> m_log;
    std::map<TrackId, std::shared_ptr<MediaFormat>> m_formats;
    std::map<int, int> m_trackSampleCounts;
    std::vector<std::shared_ptr<Mp4Track>> m_selectedTracks;
    int m_samplesRead;
    uint8_t m_nalLengthSize;
    MediaTime m_seekTime;
    bool m_streamEnded;
    bool m_haveHeader;
    std::unique_ptr<Stream> m_stream;
    std::unique_ptr<CEACaptions> m_ceaCaptions;
};
}
}
