#include "SampleEncrypterAES.hpp"
#include <cassert>

namespace twitch {
namespace media {
SampleEncrypterAES::SampleEncrypterAES(CipherMode mode, const Key_t& key, const std::array<uint8_t, 16>& iv)
    : m_mode(mode)
{
    switch (mode) {
    case ModeCTR:
        assert(AesBlockSize == iv.size() || (AesBlockSize >> 1) == iv.size());
        AES_init_ctx_iv(&m_aes, key.data(), iv.data());
        break;

    case ModeCBC:
        assert(AesBlockSize == iv.size());
        m_iv = iv;
        AES_init_ctx_iv(&m_aes, key.data(), m_iv.data());
        break;
    }
}

std::vector<uint8_t> SampleEncrypterAES::encode(const uint8_t* data, size_t size)
{
    std::vector<uint8_t> cypherText(data, data + size);

    switch (m_mode) {
    case ModeCTR:
        AES_CTR_xcrypt_buffer(&m_aes, cypherText.data(), cypherText.size());
        break;

    case ModeCBC:
        AES_CBC_encrypt_buffer(&m_aes, cypherText.data(), cypherText.size());
        break;
    }
    return cypherText;
}

void SampleEncrypterAES::endSubSample()
{
}

void SampleEncrypterAES::startSubSample()
{
    if (m_mode == ModeCBC) {
        AES_ctx_set_iv(&m_aes, m_iv.data());
    }
}
}
}
