#pragma once

#include "SampleEncrypter.hpp"
#include "tinyaes/aes.hpp"
#include <memory>
#include <vector>

namespace twitch {
namespace media {
class SampleEncrypterAES : public SampleEncrypter {
public:
    enum CipherMode {
        ModeCTR,
        ModeCBC,
    };
    SampleEncrypterAES(CipherMode mode, const Key_t& key, const std::array<uint8_t, 16>& iv);
    ~SampleEncrypterAES() override = default;
    std::vector<uint8_t> encode(const uint8_t* data, size_t size) override;
    void endSubSample() override;
    void startSubSample() override;

private:
    CipherMode m_mode;
    struct AES_ctx m_aes;
    std::array<uint8_t, 16> m_iv;
};
}
}
