#pragma once
#include "Mp4Track.hpp"
#include "fmp4.hpp"
#include "media/fourcc.hpp"
#include "mp4types.hpp"
#include <cstring>

#define BOX_HEADER_SIZE 8
#define FULLBOX_HEADER_SIZE 12
namespace twitch {
namespace media {
class MoovBox {
public:
    static size_t make_skip(uint8_t* data, uint32_t size = 0);
    static std::vector<uint8_t> make_skip(uint32_t size = 0);
    static std::vector<uint8_t> make_vttc(const std::string& payload);
    static std::vector<uint8_t> make_vtte();

    static size_t make_ftyp(uint8_t* data, uint32_t major_brand, uint32_t minor_version, const std::vector<uint32_t>& compatible_brands);
    static size_t make_moov(uint8_t* data, const fmp4& mp4);
    static size_t make_pssh(uint8_t* data, size_t ofst, const Uuid& systemId, const std::vector<KeyId_t>& kids, const uint8_t* payload_data, size_t payload_size);
    static size_t make_emsg(uint8_t* data, const std::string& scheme_id_uri, const std::string& value, uint32_t timescale, uint32_t presentation_time_delta, uint32_t event_duration, uint32_t id, const std::vector<uint8_t>& message_data);
    static size_t make_moof(uint8_t* data, uint32_t sequence_number, uint32_t data_offset, const fmp4& mp4);
    static size_t make_mdat(uint8_t* data, uint32_t size);

private:
    static size_t write_uint8(uint8_t* data, size_t ofst, uint8_t val);
    static size_t write_uint16(uint8_t* data, size_t ofst, uint16_t val);
    static size_t write_uint24(uint8_t* data, size_t ofst, uint32_t val);
    static size_t write_uint32(uint8_t* data, size_t ofst, uint32_t val);
    static size_t write_uint64(uint8_t* data, size_t ofst, uint64_t val);

    // There does not appear to be any singed int24 in the spec
    static size_t write_sint8(uint8_t* data, size_t ofst, int8_t val) { return write_uint8(data, ofst, static_cast<uint8_t>(val)); }
    static size_t write_sint16(uint8_t* data, size_t ofst, int16_t val) { return write_uint16(data, ofst, static_cast<uint16_t>(val)); }
    static size_t write_sint32(uint8_t* data, size_t ofst, int32_t val) { return write_uint32(data, ofst, static_cast<uint32_t>(val)); }
    static size_t write_sint64(uint8_t* data, size_t ofst, int64_t val) { return write_uint64(data, ofst, static_cast<uint64_t>(val)); }

    static size_t write_data(uint8_t* data, size_t ofst, const uint8_t* src, size_t len);
    static size_t write_data(uint8_t* data, size_t ofst, const std::vector<uint8_t>& payload);
    static size_t write_string(uint8_t* data, size_t ofst, const std::string& str);
    ///////////////////////////////////////////////////////////////////////////////
    // update_size must be called to set the correct size.
    static size_t make_box(uint8_t* data, size_t ofst, uint32_t type);
    static size_t make_full_box(uint8_t* data, size_t ofst, uint32_t type, uint8_t version, uint32_t flags);
    static size_t update_size(uint8_t* data, size_t ofst, size_t size);

    static size_t make_mvhd(uint8_t* data, size_t ofst, uint32_t next_track_id);
    static size_t make_mehd(uint8_t* data, size_t ofst, int64_t fragment_duration);
    static size_t make_trex(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_mvex(uint8_t* data, size_t ofst, const fmp4& mp4);
    static size_t make_tkhd(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_elst(uint8_t* data, size_t ofst, int32_t media_time);
    static size_t make_edts(uint8_t* data, size_t ofst, int32_t media_time);
    static size_t make_mdhd(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_hdlr(uint8_t* data, size_t ofst, uint32_t handler_type, const std::string& name);
    static size_t make_vmhd(uint8_t* data, size_t ofst);
    static size_t make_smhd(uint8_t* data, size_t ofst);
    static size_t make_nmhd(uint8_t* data, size_t ofst);
    static size_t make_url(uint8_t* data, size_t ofst, const std::string& url);
    static size_t make_dref(uint8_t* data, size_t ofst);
    static size_t make_dinf(uint8_t* data, size_t ofst);
    static size_t make_visual_sample_entry(uint8_t* data, size_t ofst, uint32_t type, const Mp4Track& track);
    static size_t make_avcc(uint8_t* data, size_t ofst, const std::vector<uint8_t>& extradata);
    static size_t make_avc1(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_vp09(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_vpcC(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_wvtt(uint8_t* data, size_t ofst);
    static size_t make_vttC(uint8_t* data, size_t ofst);
    static size_t make_vlab(uint8_t* data, size_t ofst);
    static size_t write_esds_desc(uint8_t* data, size_t ofst, uint8_t desc, size_t len);
    static size_t make_esds(uint8_t* data, size_t ofst, uint16_t trackId, const std::vector<uint8_t>& extradata);
    static size_t make_mp4a(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_stsd(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_stts(uint8_t* data, size_t ofst);
    static size_t make_stsc(uint8_t* data, size_t ofst);
    static size_t make_stsz(uint8_t* data, size_t ofst);
    static size_t make_stco(uint8_t* data, size_t ofst);
    static size_t make_stbl(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_minf(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_mdia(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_trak(uint8_t* data, size_t ofst, const Mp4Track& track);

    static size_t make_mfhd(uint8_t* data, size_t ofst, uint32_t sequence_number);
    static size_t make_tfhd(uint8_t* data, size_t ofst, const Mp4Track& track);

    static uint32_t trun_flags(const Mp4Track& track);
    static size_t make_trun(uint8_t* data, size_t ofst, uint32_t data_offset, const Mp4Track& track);
    static size_t make_tfdt(uint8_t* data, size_t ofst, int64_t base_media_decode_time, int64_t track_fragment_duration);
    static size_t make_traf(uint8_t* data, size_t ofst, uint32_t data_offset, const Mp4Track& track);

    //  DRM boxes
    static size_t SampleAuxiliaryDataSize(size_t perSampleIvSize, bool useSubSampleEncryption, const mp4sample& sample);
    static size_t make_saiz(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_saio(uint8_t* data, size_t ofst);
    static size_t make_senc(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_tenc(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_frma(uint8_t* data, size_t ofst, uint32_t data_format);
    static size_t make_schm(uint8_t* data, size_t ofst, uint32_t scheme_type);
    static size_t make_schi(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_sinf(uint8_t* data, size_t ofst, const Mp4Track& track);

    // WebVTT CC boxes
    static size_t make_vttc(uint8_t* data, const std::string& payload);
    static size_t make_payl(uint8_t* data, size_t ofst, const std::string& payload);
    static size_t make_vtte(uint8_t* data);

    // Opus boxes
    static size_t make_Opus(uint8_t* data, size_t ofst, const Mp4Track& track);
    static size_t make_dOps(uint8_t* data, size_t ofst, const Mp4Track& track);
};
}
}
