#pragma once
#include "../aac/aacutil.hpp"
#include "../avc/avcutil.hpp"
#include "EncryptionInfo.hpp"
#include "Mp4DrmFactory.hpp"
#include "Mp4Track.hpp"
#include "SampleEncrypter.hpp"
#include "mp4sample.hpp"
#include "mp4types.hpp"
#include "playercore/MediaSample.hpp"
#include <cinttypes>
#include <string>
#include <vector>

namespace twitch {
namespace media {
class fmp4track_aac : public Mp4Track {
public:
    bool addSample(int64_t dts, int32_t cts, uint32_t duration, uint32_t flags, const uint8_t* data, uint32_t size) override;
    fmp4track_aac(uint32_t trackId, uint32_t timescale,
        uint32_t defaultSampleSize, uint32_t defaultSampleFlags, uint32_t defaultSampleDuration,
        int32_t elstMediaTime, const std::vector<uint8_t>& extradata,
        const std::vector<EncryptionInfo>& encryptionInfo);
};

class fmp4track_avc : public Mp4Track {
private:
    int m_lengthSize = 4;
    size_t m_bytesOfClearData = 0;
    mp4sample m_sample;
    AVCParser m_avcParser;
    std::shared_ptr<SampleEncrypter> m_drm;
    std::vector<uint8_t> m_sampleData;

public:
    void clearSample();
    bool addSample(int64_t dts, int32_t cts, uint32_t duration, uint32_t flags, const uint8_t* data, uint32_t size) override;
    fmp4track_avc(uint32_t trackId, uint32_t timescale,
        uint32_t defaultSampleSize, uint32_t defaultSampleFlags, uint32_t defaultSampleDuration,
        int32_t elstMediaTime, const std::vector<uint8_t>& extradata,
        const std::vector<EncryptionInfo>& encryptionInfo);

private:
    void startSample(int64_t dts, int32_t cts, uint32_t duration, uint32_t flags);
    void updateSubsampleInfo(size_t bytesOfProtectedData);
    void addNalu(const uint8_t* data, size_t size);
    bool finishSample();
};

class fmp4track_vp9 : public Mp4Track {
public:
    struct VP9ConfigurationRecord {
        uint32_t width;
        uint32_t height;
        uint8_t profile;
        uint8_t level;
        uint8_t bitDepth;
        uint8_t chromaSubsampling;
        uint8_t videoFullRangeFlag;
        uint8_t colourPrimaries;
        uint8_t transferCharacteristics;
        uint8_t matrixCoefficients;
    };

    const VP9ConfigurationRecord& getConfigurationRecord() const { return m_configurationRecord; }

    fmp4track_vp9(uint32_t trackId, uint32_t timescale,
        uint32_t defaultSampleSize, uint32_t defaultSampleFlags, uint32_t defaultSampleDuration,
        int32_t elstMediaTime, const VP9ConfigurationRecord& configurationRecord);

private:
    VP9ConfigurationRecord m_configurationRecord;
};

class fmp4track_webvtt : public Mp4Track {
public:
    fmp4track_webvtt(uint32_t trackId, uint32_t timescale,
        uint32_t defaultSampleSize, uint32_t defaultSampleFlags, uint32_t defaultSampleDuration,
        int32_t elstMediaTime);
};

class fmp4track_opus : public Mp4Track {
public:
    struct OpusConfiguration {
        uint8_t version;
        uint8_t outputChannelCount;
        uint16_t preSkip;
        uint32_t inputSampleRate;
        int16_t outputGain;
        uint8_t channelMappingFamily;
    };

    // optional struct used only if channelMappingFamily is valid
    struct ChannelMappingTable {
        uint8_t streamCount;
        uint8_t coupledCount;
        uint32_t channelMapping;
    };

    fmp4track_opus(uint32_t trackId, uint32_t timescale,
        uint32_t defaultSampleSize, uint32_t defaultSampleFlags, uint32_t defaultSampleDuration,
        int32_t elstMediaTime, const OpusConfiguration& opusConfig);

private:
    OpusConfiguration m_opusConfig;
};
}
}
