#pragma once

#include <cstdint>
#include <vector>

namespace twitch {
namespace media {
struct mp4sample {
    // flags:
    //bit(4) reserved=0;
    //unsigned int(2) is_leading;
    //unsigned int(2) sample_depends_on;
    //unsigned int(2) sample_is_depended_on;
    //unsigned int(2) sample_has_redundancy;
    //bit(3) sample_padding_value;
    //bit(1) sample_is_non_sync_sample;
    //unsigned int(16) sample_degradation_priority;
    enum SampleFlags : uint32_t {
        // is_leading takes one of the following four values:
        // 0: the leading nature of this sample is unknown;
        // 1: this sample is a leading sample that has a dependency before the referenced I-picture
        // (and is therefore not decodable);
        // 2: this sample is not a leading sample;
        // 3: this sample is a leading sample that has no dependency before the referenced I-picture
        // (and is therefore decodable);
        SampleIsLeadingYes = (1 << 26),
        SampleIsLeadingNo = (2 << 26),
        SampleIsLeadingDecodable = (3 << 26), // closed GOP B frame?
        SampleDependsOnOthersYes = (1 << 24),
        SampleDependsOnOthersNo = (2 << 24),
        SampleIsDependedOnYes = (1 << 22),
        SampleIsDependedOnNo = (2 << 22),
        SampleHasRedundancyYes = (1 << 20),
        SampleHasRedundancyNo = (2 << 20),
        SampleIsNonSync = (1 << 16),
    };

    int64_t decodeTime = 0; // TODO remove only used for writing
    uint32_t duration = 0;
    uint32_t size = 0;
    uint32_t flags = 0;
    int32_t compositionTimeOffset = 0;
    uint32_t chunkIndex = 0;
    uint32_t chunkNumber = 0;
    uint32_t sampleGroup = 0;
    std::vector<uint8_t> initializationVector;
    std::vector<std::pair<uint16_t, uint32_t>> subsampleRange;
};
}
}
