#pragma once

#include "media/fourcc.hpp"
#include <cstdint>
#include <vector>

namespace twitch {
namespace media {
enum mp4boxtype {
    MP4_ftyp = fourcc("ftyp"),
    MP4_pdin = fourcc("pdin"),
    MP4_mvhd = fourcc("mvhd"),
    MP4_mdhd = fourcc("mdhd"),
    MP4_moov = fourcc("moov"),
    MP4_trak = fourcc("trak"),
    MP4_tkhd = fourcc("tkhd"),
    MP4_tref = fourcc("tref"),
    MP4_trgr = fourcc("trgr"),
    MP4_edts = fourcc("edts"),
    MP4_elst = fourcc("elst"),
    MP4_emsg = fourcc("emsg"),
    MP4_mdia = fourcc("mdia"),
    MP4_minf = fourcc("minf"),
    MP4_vmhd = fourcc("vmhd"),
    MP4_smhd = fourcc("smhd"),
    MP4_hmhd = fourcc("hmhd"),
    MP4_nmhd = fourcc("nmhd"),
    MP4_dinf = fourcc("dinf"),
    MP4_dref = fourcc("dref"),
    MP4_stbl = fourcc("stbl"),
    MP4_stsd = fourcc("stsd"),
    MP4_stts = fourcc("stts"),
    MP4_ctts = fourcc("ctts"),
    MP4_cslg = fourcc("cslg"),
    MP4_stsc = fourcc("stsc"),
    MP4_stsz = fourcc("stsz"),
    MP4_stz2 = fourcc("stz2"),
    MP4_stco = fourcc("stco"),
    MP4_co64 = fourcc("co64"),
    MP4_stss = fourcc("stss"),
    MP4_stsh = fourcc("stsh"),
    MP4_padb = fourcc("padb"),
    MP4_stdp = fourcc("stdp"),
    MP4_sbgp = fourcc("sbgp"),
    MP4_sgpd = fourcc("sgpd"),
    MP4_subs = fourcc("subs"),
    MP4_saiz = fourcc("saiz"),
    MP4_saio = fourcc("saio"),
    MP4_udta = fourcc("udta"),
    MP4_mvex = fourcc("mvex"),
    MP4_mehd = fourcc("mehd"),
    MP4_trex = fourcc("trex"),
    MP4_leva = fourcc("leva"),
    MP4_moof = fourcc("moof"),
    MP4_mfhd = fourcc("mfhd"),
    MP4_traf = fourcc("traf"),
    MP4_tfhd = fourcc("tfhd"),
    MP4_trun = fourcc("trun"),
    MP4_tfdt = fourcc("tfdt"),
    MP4_mfra = fourcc("mfra"),
    MP4_tfra = fourcc("tfra"),
    MP4_mfro = fourcc("mfro"),
    MP4_mdat = fourcc("mdat"),
    MP4_free = fourcc("free"),
    MP4_skip = fourcc("skip"),
    MP4_cprt = fourcc("cprt"),
    MP4_tsel = fourcc("tsel"),
    MP4_strk = fourcc("strk"),
    MP4_stri = fourcc("stri"),
    MP4_strd = fourcc("strd"),
    MP4_meta = fourcc("meta"),
    MP4_hdlr = fourcc("hdlr"),
    MP4_iloc = fourcc("iloc"),
    MP4_ipro = fourcc("ipro"),
    MP4_sinf = fourcc("sinf"),
    MP4_frma = fourcc("frma"),
    MP4_schm = fourcc("schm"),
    MP4_schi = fourcc("schi"),
    MP4_meco = fourcc("meco"),
    MP4_styp = fourcc("styp"),
    MP4_sidx = fourcc("sidx"),
    MP4_ssix = fourcc("ssix"),
    MP4_prft = fourcc("prft"),
    MP4_uuid = fourcc("uuid"),
    MP4_vttc = fourcc("vttc"),
    MP4_vtte = fourcc("vtte"),
    MP4_vttx = fourcc("vttx"),
    MP4_iden = fourcc("iden"),
    MP4_sttg = fourcc("sttg"),
    MP4_pasp = fourcc("pasp"),
    MP4_payl = fourcc("payl"),
    MP4_clap = fourcc("clap"),
    MP4_pssh = fourcc("pssh"),
    MP4_seio = fourcc("seio"),
    MP4_sesz = fourcc("sesz"),
    MP4_senc = fourcc("senc"),
    MP4_tenc = fourcc("tenc"),
    MP4_dops = fourcc("dOps"),
    // codec specific boxes
    MP4_avc1 = fourcc("avc1"),
    MP4_vp09 = fourcc("vp09"),
    MP4_enca = fourcc("enca"),
    MP4_encv = fourcc("encv"),
    MP4_mp4a = fourcc("mp4a"),
    MP4_avcC = fourcc("avcC"),
    MP4_vpcC = fourcc("vpcC"),
    MP4_esds = fourcc("esds"),
    MP4_wvtt = fourcc("wvtt"),
    MP4_vttC = fourcc("vttC"),
    MP4_vlab = fourcc("vlab"),
    MP4_opus = fourcc("Opus"),

    // Sample grouping types
    MP4_seig = fourcc("seig"),
};

enum mp4handlertype {
    MP4_vide = fourcc("vide"),
    MP4_soun = fourcc("soun"),
    MP4_hint = fourcc("hint"),
    MP4_text = fourcc("text"),
};

struct mp4box {
    uint64_t size = 0;
    uint32_t type = 0;
    uint8_t usertype[16];
    size_t data; // data offset
};

struct mp4ftyp {
    uint32_t major_brand;
    uint32_t minor_version;
    uint32_t compatible_brand;
};

struct mp4mvhd {
    uint64_t creation_time;
    uint64_t modification_time;
    uint32_t timescale;
    uint64_t duration;
};

struct mp4tkhd {
    uint64_t creation_time;
    uint64_t modification_time;
    uint32_t track_ID;
    uint32_t reserved1;
    uint64_t duration;
    uint32_t reserved2[2];
    uint16_t layer;
    uint16_t alternate_group;
    uint16_t volume;
    uint16_t reserved3;
    uint32_t matrix[9];
    uint32_t width;
    uint32_t height;
};

enum mp4tfhd_flag {
    TFHD_BASE_DATA_OFFSET = 0x01,
    TFHD_STSD_ID = 0x02,
    TFHD_DEFAULT_DURATION = 0x08,
    TFHD_DEFAULT_SIZE = 0x10,
    TFHD_DEFAULT_FLAGS = 0x20,
    TFHD_DURATION_IS_EMPTY = 0x10000,
    TFHD_DEFAULT_BASE_IS_MOOF = 0x20000,
};

struct mp4mdhd {
    uint64_t creation_time;
    uint64_t modification_time;
    uint32_t timescale;
    uint64_t duration;
};

struct mp4tfhd {
    uint32_t tf_flags;
    uint32_t track_ID;
    uint64_t base_data_offset;
    uint32_t sample_description_index;
    uint32_t default_sample_duration;
    uint32_t default_sample_size;
    uint32_t default_sample_flags;
};

enum mp4trun_flag {
    TRUN_DATA_OFFSET = 0x001,
    TRUN_FIRST_SAMPLE_FLAGS = 0x004,
    TRUN_SAMPLE_DURATION = 0x100,
    TRUN_SAMPLE_SIZE = 0x200,
    TRUN_SAMPLE_FLAGS = 0x400,
    TRUN_SAMPLE_CTS = 0x800,
};

struct mp4trun {
    uint32_t sample_flags;
    uint32_t sample_count;
    uint32_t data_offset;
    uint32_t first_sample_flags;
    uint32_t default_sample_duration;
    uint32_t default_sample_size;
    uint32_t default_sample_flags;
};

struct mp4chunk {
    uint64_t offset = 0;
    uint32_t sample_count = 0;
    uint32_t sample_description_index = 0;
};

struct mp4visual {
    // sample entry
    uint8_t reserved1[6];
    uint16_t data_reference_index;
    // visual sample entry
    uint16_t pre_defined1;
    uint16_t reserved2;
    uint8_t pre_defined2[12];
    uint16_t width;
    uint16_t height;
    uint32_t horizresolution;
    uint32_t vertresolution;
    uint32_t reserved3;
    uint16_t frame_count;
    uint8_t compressorname[32];
    uint16_t depth;
    uint16_t pre_defined3;
};

struct mp4vp9 {
    uint8_t profile;
    uint8_t level;
    uint8_t bitDepth;
    uint8_t chromaSubsampling;
    bool videoFullRangeFlag;
    uint8_t colourPrimaries;
    uint8_t transferCharacteristics;
    uint8_t matrixCoefficients;
    uint16_t codecIntializationDataSize;
    std::vector<uint8_t> codecIntializationData;
};

struct mp4audio {
    uint32_t reserved1[2];
    uint16_t channelcount;
    uint16_t samplesize;
    uint16_t pre_defined;
    uint16_t reserved2;
    uint32_t samplerate;
};

enum ESDSObjectType {
    AAC_Main = 1,
    AAC_LC = 2,
    AAC_SSR = 3,
    AAC_LTP = 4,
    SBR = 5,
    AAC_Scalable = 6
};

struct mp4pasp { // Pixel Aspect Ratio Box
    uint32_t hSpacing;
    uint32_t vSpacing;
};

struct mp4pssh {
    uint8_t systemId[16];
    uint32_t keyIdCount;
    // Not doing anything with the keys yet
};

struct mp4emsg {
    std::string scheme_id_uri;
    std::string value;
    uint32_t timescale;
    uint32_t presentation_time_delta;
    uint32_t event_duration;
    uint32_t id;
    std::vector<uint8_t> data;
};
}
}
