#pragma once

#include "playercore/platform/HttpMethod.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
class AsyncHttpClient : public HttpClient, public std::enable_shared_from_this<AsyncHttpClient> {
public:
    friend class AsyncHttpRequest;
    friend class AsyncHttpResponse;
    AsyncHttpClient(Platform& platform, std::shared_ptr<Scheduler> scheduler);
    ~AsyncHttpClient() override = default;
    std::shared_ptr<HttpRequest> createRequest(const std::string& url, HttpMethod method) override;
    void send(std::shared_ptr<HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError) override;

private:
    std::shared_ptr<HttpClient> m_httpClient;
    std::shared_ptr<Scheduler> m_ioScheduler;
    std::shared_ptr<Scheduler> m_targetScheduler;
};
}
