#include "AsyncHttpRequest.hpp"

namespace twitch {
AsyncHttpRequest::AsyncHttpRequest(const std::string& url,
    HttpMethod method,
    std::shared_ptr<HttpRequest> request)
    : HttpRequest(url, method)
    , m_request(std::move(request))
    , m_cancelled(false)
{
}

void AsyncHttpRequest::setHeader(const std::string& key, const std::string& value)
{
    m_request->setHeader(key, value);
}

void AsyncHttpRequest::setContent(const std::vector<uint8_t>& content)
{
    m_request->setContent(content);
}

bool AsyncHttpRequest::isCancelled()
{
    return m_cancelled;
}

void AsyncHttpRequest::cancel()
{
    std::lock_guard<RecursiveMutex> lock(getMutex());

    if (isCancelled()) {
        return;
    }
    m_request->cancel();
    m_cancelled = true;
}
}
