#pragma once

#include "playercore/platform/HttpMethod.hpp"
#include "playercore/platform/Platform.hpp"
#include "util/Concurrency.hpp"

namespace twitch {
class AsyncHttpRequest : public HttpRequest {
public:
    AsyncHttpRequest(const std::string& url, HttpMethod method, std::shared_ptr<HttpRequest> request);
    ~AsyncHttpRequest() override = default;
    bool isCancelled();
    void cancel() override;
    void setHeader(const std::string& key, const std::string& value) override;
    void setContent(const std::vector<uint8_t>& content) override;
    std::shared_ptr<HttpRequest> getRequest() { return m_request; };
    RecursiveMutex& getMutex() { return m_mutex; }

private:
    std::shared_ptr<HttpRequest> m_request;
    RecursiveMutex m_mutex;
    bool m_cancelled;
};
}
