#pragma once

#include "AsyncHttpClient.hpp"
#include "AsyncHttpRequest.hpp"

namespace twitch {
class AsyncHttpResponse : public HttpResponse {
public:
    AsyncHttpResponse(std::shared_ptr<AsyncHttpRequest> request,
        std::shared_ptr<HttpResponse> response,
        std::weak_ptr<AsyncHttpClient> client);
    ~AsyncHttpResponse() override = default;
    std::string getHeader(const std::string& key) const override;
    void setReadTimeout(std::chrono::seconds timeout) override;
    void read(ContentHandler onBuffer, ErrorHandler onError) override;

private:
    std::weak_ptr<AsyncHttpRequest> m_request;
    std::shared_ptr<HttpResponse> m_response;
    std::weak_ptr<AsyncHttpClient> m_client;
};
}
