#pragma once

#include "playercore/MediaTime.hpp"

namespace twitch {
struct BufferRange {
    // differs from TImeRange since we need explicit start/end times
    MediaTime start = MediaTime::zero();
    MediaTime end = MediaTime::invalid();

    BufferRange() = default;
    BufferRange(MediaTime start, MediaTime end)
        : start(start)
        , end(end)
    {
    }

    MediaTime duration() const { return end - start; }
    bool contains(MediaTime time) const { return time >= start && time < end; }
    bool operator==(const BufferRange& other) const { return start == other.start && end == other.end; }
    bool operator!=(const BufferRange& other) const { return !(*this == other); }
    bool operator<(const BufferRange& other) const { return other.start >= end; }
    bool operator>(const BufferRange& other) const { return start >= other.end; }
};
}
