#pragma once

namespace twitch {
/** The current status of the player's buffer */
enum class BufferState {
    /** Uninitialized state */
    Uninitialized,
    /** Filling buffer before playback */
    Filling,
    /** Filling buffer for playback after the buffer was drained while playing */
    Refilling,
    /** Normal playback buffer is being drained */
    Draining,
};
const char* bufferStateToString(BufferState state);
}
