#include "Error.hpp"

namespace twitch {

static int resultId() noexcept
{
    static int value = 0;
    return value++;
}

const MediaResult MediaResult::Ok(resultId());
const MediaResult MediaResult::Error(resultId());
const MediaResult MediaResult::ErrorNotSupported(resultId());
const MediaResult MediaResult::ErrorNoSource(resultId());
const MediaResult MediaResult::ErrorInvalidData(resultId());
const MediaResult MediaResult::ErrorInvalidState(resultId());
const MediaResult MediaResult::ErrorInvalidParameter(resultId());
const MediaResult MediaResult::ErrorTimeout(resultId());
const MediaResult MediaResult::ErrorInvalidOutput(resultId());
const MediaResult MediaResult::ErrorInternal(resultId());
const MediaResult MediaResult::ErrorNetwork(resultId());
const MediaResult MediaResult::ErrorNetworkIO(resultId());
const MediaResult MediaResult::ErrorAuthorization(resultId());
const MediaResult MediaResult::ErrorNotAvailable(resultId());

const char* mediaResultString(const MediaResult& result)
{
    const char* mediaResultNames[] = {
        "Ok",
        "Error",
        "ErrorNotSupported",
        "ErrorNoSource",
        "ErrorInvalidData",
        "ErrorInvalidState",
        "ErrorInvalidParameter",
        "ErrorTimeout",
        "ErrorInvalidOutput",
        "ErrorInternal",
        "ErrorNetwork",
        "ErrorNetworkIO",
        "ErrorAuthorization",
        "ErrorNotAvailable",
    };
    return mediaResultNames[result.value];
}

const char* errorSourceString(ErrorSource result)
{
    const char* errorSourceNames[] = {
        "Unspecified",
        "File",
        "Playlist",
        "Segment",
        "Source",
        "Decode",
        "Render",
    };
    return errorSourceNames[static_cast<int>(result)];
}
}
