#include "PassthroughSource.hpp"
#include "media/MediaReader.hpp"
#include "media/SourceFormat.hpp"

namespace twitch {
PassthroughSource::PassthroughSource(MediaSource::Listener& listener, const MediaType& mediaType, const std::string& path, bool remote)
    : m_listener(listener)
    , m_mediaType(mediaType)
    , m_path(path)
    , m_opened(false)
    , m_remote(remote)
{
}

void PassthroughSource::open()
{
    if (!m_opened) {
        m_opened = true;
        m_listener.onSourceOpened();
    }
    auto format = std::make_shared<media::SourceFormat>(m_mediaType);
    format->setPath(m_path);
    if (m_remote) {
        format->setName("remote");
    }
    m_listener.onSourceTrack(media::MediaReader::VideoTrackId, format);
    m_listener.onSourceFlush();
}

void PassthroughSource::close()
{
    m_opened = false;
}

void PassthroughSource::seekTo(MediaTime time)
{
    (void)time;
}

void PassthroughSource::read(const TimeRange& range)
{
    (void)range;
}
}
