#pragma once
#include "playercore/MediaSource.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
class PassthroughSource : public MediaSource {
public:
    PassthroughSource(MediaSource::Listener& listener, const MediaType& mediaType, const std::string& path, bool remote = false);
    virtual ~PassthroughSource() = default;
    PassthroughSource(const PassthroughSource&) = delete;
    const PassthroughSource& operator=(const PassthroughSource&) = delete;

    void open() override;
    void close() override;
    void seekTo(MediaTime time) override;
    void read(const TimeRange& range) override;
    bool isLive() const override { return false; }
    bool isSeekable() const override { return true; }
    bool isPassthrough() const override { return true; }
    MediaTime getDuration() const override { return m_duration; }
    const Quality& getQuality() const override { return m_quality; }
    void setQuality(const Quality&, bool) override {}
    const std::vector<Quality>& getQualities() const override { return m_qualities; }
    void setReadTimeout(MediaTime) override {}
    void setLowLatencyEnabled(bool) override {}

private:
    MediaSource::Listener& m_listener;
    MediaType m_mediaType;
    std::string m_path;
    std::vector<Quality> m_qualities;
    Quality m_quality;
    MediaTime m_duration;
    bool m_opened;
    bool m_remote;
};
}
