#include "Playhead.hpp"

namespace twitch {
Playhead::Playhead()
    : m_interval(0.1)
    , m_playbackRate(1.0)
{
    reset();
}

MediaTime Playhead::getPosition() const
{
    // if seeking return the seek time to the buffer end instead of the current time
    return m_seekCompleted && m_time > MediaTime::zero() ? m_time : m_seekTime;
}

void Playhead::reset()
{
    m_time = MediaTime::zero();
    m_seekTime = MediaTime::zero();
    m_lastTick = MediaTime::zero();
    m_seekCompleted = true;
}

void Playhead::seekTo(MediaTime time)
{
    m_time = time;
    m_seekTime = time;
    m_seekCompleted = false;
}

void Playhead::seekCompleted()
{
    m_seekCompleted = true;
}

bool Playhead::setPosition(MediaTime time)
{
    if (m_seekCompleted) {
        m_time = time;
        // return true if m_interval time has passed
        if (time - m_lastTick > m_interval) {
            m_lastTick = time;
            return true;
        }
    }
    return false;
}
}
