#pragma once

#include "playercore/MediaTime.hpp"
#include "playercore/TimeRange.hpp"

namespace twitch {
class Playhead {
public:
    Playhead();
    virtual ~Playhead() = default;

    float getPlaybackRate() const { return m_playbackRate; }
    MediaTime getPosition() const;
    MediaTime getInterval() const { return m_interval; }
    bool isSeeking() { return !m_seekCompleted; }
    void reset();
    void seekTo(MediaTime time);
    void seekCompleted();
    bool setPosition(MediaTime time);
    void setPlaybackRate(float rate) { m_playbackRate = rate; }

private:
    MediaTime m_seekTime;
    MediaTime m_lastTick;
    MediaTime m_interval;
    MediaTime m_time;
    bool m_seekCompleted;
    float m_playbackRate;
};
}
