#pragma once

#include "playercore/Quality.hpp"
#include "playercore/platform/Platform.hpp"
#include <vector>

namespace twitch {
class Qualities {
public:
    Qualities() = default;
    virtual ~Qualities() = default;

    void clear();
    bool isEmpty() { return m_qualities.empty(); }
    Quality match(const Quality& quality) const;
    Quality match(int bitrate) const;
    void reset(Platform& platform, const std::vector<Quality>& qualities);
    void remove(const Quality& quality, bool autoOnly = false);
    void setCurrent(const Quality& quality);
    void setSelected(const Quality& quality);
    const Quality& getCurrent() const { return m_current; }
    const Quality& getPrevious() const { return m_previous; }
    const Quality& getSelected() const { return m_selected; }
    const std::vector<Quality>& getQualities() const { return m_qualities; }
    const std::vector<Quality>& getAutoQualities() const { return m_autoQualities; }

private:
    bool isSupported(Platform& platform, const Quality& quality) const;
    const Quality& getDefault() const;

    Quality m_current;
    Quality m_previous;
    Quality m_selected;
    std::vector<Quality> m_qualities;
    std::vector<Quality> m_autoQualities;
};
}
