#include "Settings.hpp"

namespace twitch {
Settings::Settings(const json11::Json& json)
{
    load(json);
}

Settings::Settings(const std::string& json)
{
    load(json);
}

bool Settings::load(const json11::Json& json)
{
    if (!json.is_object()) {
        return false;
    }

    // Validate settings schema
    for (const auto& module : json.object_items()) {
        if (!module.second.is_object()) {
            return false;
        }
    }

    m_settings = json.object_items();
    return true;
}

bool Settings::load(const std::string& json)
{
    std::string err;
    auto parsed = json11::Json::parse(json, err);
    return err.empty() ? load(parsed) : false;
}

std::string Settings::dump() const
{
    return json11::Json(m_settings).dump();
}

bool Settings::has(const std::string& mod) const
{
    return m_settings.end() != m_settings.find(mod);
}

template <>
bool Settings::extract<bool>(const json11::Json& val) const
{
    return val.bool_value();
}

template <>
std::string Settings::extract<std::string>(const json11::Json& val) const
{
    return val.string_value();
}
}
