#pragma once

#include <json11.hpp>

namespace twitch {
class Settings {
public:
    Settings() = default;
    Settings(const json11::Json& json);
    Settings(const std::string& json);

    bool load(const json11::Json& json);
    bool load(const std::string& json);
    std::string dump() const;
    bool has(const std::string& mod) const;

    template <typename T>
    T get(const std::string& mod, const std::string& key, T defaultVal) const
    {
        const auto modIter = m_settings.find(mod);

        if (modIter == m_settings.end()) {
            return defaultVal;
        }

        const auto& modSettings = modIter->second.object_items();
        const auto keyIter = modSettings.find(key);

        return keyIter != modSettings.end() ? extract<T>(keyIter->second) : defaultVal;
    }

private:
    // Extract value from settings json by type
    template <typename T>
    T extract(const json11::Json& val) const
    {
        if (std::is_floating_point<T>::value) {
            return static_cast<T>(val.number_value());
        } else {
            return static_cast<T>(val.int_value());
        }
    }

    json11::Json::object m_settings;
};

template <>
bool Settings::extract<bool>(const json11::Json& val) const;

template <>
std::string Settings::extract<std::string>(const json11::Json& val) const;
}
