#pragma once

#include "playercore/Statistics.hpp"

namespace twitch {
class VideoStatistics : public Statistics {
public:
    VideoStatistics()
    {
        reset();
    }

    VideoStatistics(const Statistics& statistics)
    {
        copy(statistics);
    }

    void copy(const Statistics& statistics)
    {
        m_bitRate = statistics.getBitRate();
        m_frameRate = statistics.getFrameRate();
        m_decodedFrames = statistics.getDecodedFrames();
        m_droppedFrames = statistics.getDroppedFrames();
        m_renderedFrames = statistics.getRenderedFrames();
    }

    void reset()
    {
        m_bitRate = 0;
        m_frameRate = 0;
        m_droppedFrames = 0;
        m_decodedFrames = 0;
        m_renderedFrames = 0;
    }

    int getBitRate() const override { return m_bitRate; }
    int getFrameRate() const override { return m_frameRate; }
    int getDecodedFrames() const override { return m_decodedFrames; }
    int getDroppedFrames() const override { return m_droppedFrames; }
    int getRenderedFrames() const override { return m_renderedFrames; }

    void setBitRate(int value) { m_bitRate = value; }
    void setFrameRate(int value) { m_frameRate = value; }
    void setDecodedFrames(int count) { m_decodedFrames = count; }
    void setDroppedFrames(int count) { m_droppedFrames = count; }
    void setRenderedFrames(int count) { m_renderedFrames = count; }

private:
    int m_bitRate;
    int m_frameRate;
    int m_droppedFrames;
    int m_decodedFrames;
    int m_renderedFrames;
};
}
