#pragma once

#include "playercore/Cancellable.hpp"
#include <memory>

namespace twitch {
class CancellableRef : public Cancellable {
public:
    CancellableRef() = default;
    ~CancellableRef() override = default;
    CancellableRef(std::shared_ptr<Cancellable> cancellable)
        : m_cancellable(std::move(cancellable))
    {
    }
    void cancel() override
    {
        if (m_cancellable) {
            m_cancellable->cancel();
        }
    }

private:
    std::shared_ptr<Cancellable> m_cancellable;
};
}
