#pragma once

#include "playercore/Cancellable.hpp"
#include <atomic>

namespace twitch {
class CancellationFlag : public Cancellable {
public:
    CancellationFlag()
        : m_cancelled(false)
    {
    }
    ~CancellationFlag() override = default;
    bool isCancelled() { return m_cancelled; }
    void cancel() override
    {
        m_cancelled = true;
    }

private:
    std::atomic<bool> m_cancelled;
};
}
