#pragma once

#include "DrmProvider.hpp"
#include "player/MediaRequest.hpp"
#include "player/ScopedScheduler.hpp"
#include "playercore/MediaFormat.hpp"
#include "playercore/platform/NativePlatform.hpp"
#include "util/Uuid.hpp"
#include <map>

namespace twitch {
class DrmClient : private DrmSession::Listener, DrmProvider::Listener, ScopedScheduler {
public:
    class Listener {
    public:
        virtual ~Listener() = default;
        virtual void onKeysProvided() = 0;
        virtual void onProtectionError(const Error& error) = 0;
    };

    DrmClient(NativePlatform& platform, Listener& listener, const std::shared_ptr<Scheduler>& scheduler);
    ~DrmClient() override;
    bool onProtectedMedia(const MediaFormat& format);
    bool isKeyUpdated() const { return m_keyState == KeyState::Updated; }

private:
    void onKeyExpired(DrmSession& session) override;
    void onKeyRequested(DrmSession& session) override;
    void onProvisioningRequested(DrmSession& session) override;
    void onError(DrmSession& session, const Error& error) override;
    void onProviderPrepared() override;
    void onProviderError(const Error& error) override;

    void postRequest(DrmSession& session, const std::string& type, const DrmSession::OpaqueRequest& opaqueRequest);
    void onResponse(MediaRequest& request, HttpResponse& response, DrmSession& session);
    void onResponseData(MediaRequest& request, DrmSession& session, const std::vector<uint8_t>& data);
    void onRequestError(MediaRequest& request, MediaResult result, int error, const std::string& message);
    void removeRequest(int id);
    bool isProvisioning() const;

    enum KeyState {
        Initialized,
        Pending,
        Updated,
        Expired,
        Errored
    };

    NativePlatform& m_platform;
    Listener& m_listener;
    std::shared_ptr<Log> m_log;
    std::shared_ptr<HttpClient> m_httpClient;
    Uuid m_systemID;
    std::vector<uint8_t> m_initializationData;
    std::unique_ptr<DrmSession> m_session;
    std::unique_ptr<DrmProvider> m_provider;
    bool m_providerPrepared;
    KeyState m_keyState;
    std::vector<MediaRequest> m_requests;
};
}
