#pragma once

#include "player/MediaRequest.hpp"
#include "playercore/MediaFormat.hpp"

namespace twitch {
class DrmProvider {
public:
    class Listener {
    public:
        virtual ~Listener() = default;
        virtual void onProviderPrepared() = 0;
        virtual void onProviderError(const Error& error) = 0;
    };

    virtual ~DrmProvider() = default;
    virtual std::string getLicenseAcquisitionUrl() = 0;
    virtual void onLicenseRequest(HttpRequest& request) = 0;
    virtual void prepare(const MediaFormat& format) = 0;
};
}
